<?php
/*
  This action makes all assoc lists' keys ("titles") be anchored. Example:
    = this is anchored even if the action call is placed later.
    {{AnchorizeAssocLists}}
    = anchored as well == item body.
*/

class Uanchorizeassoclists_Root extends UWikiBaseAction {
  // dynamic actions are ran when rendering is in progress - that's exactly what
  // we need since we're rendering list items' nodes into HTML.
  function IsDynamic($format, $params) { return true; }

  function Execute($format, $params) {
    $items = &$format->root->doc->elements['wacko_ListItem'];
    if ($items) {
      foreach ($items as $obj) {
        if ($obj->markerType === 'assoc') {
          // todo: use ToText when we have it.
          $obj->AnchorizeIfNeeds( strip_tags($obj->TermElement()->ChildrenToHTML()) );
        }
      }
    }
  }
}
